/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.base.logging.Logger;
import java.util.Vector;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.OverviewURL;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.InstanceParms;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.error.RegistryException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSUDDIUtils {
    protected static final Logger logger = Logger.getLogger("filenet.ws.api.uddi.WSUDDIUtils");
    protected static final String m_className = "WSUddiManager";
    static String UDDI_accessPoint = "accessPoint";
    static String UDDI_aclBag = "aclBag";
    static String UDDI_address = "address";
    static String UDDI_addressLine = "addressLine";
    static String UDDI_authorizedName = "authorizedName";
    static String UDDI_bindingKey = "bindingKey";
    static String UDDI_bindingTemplate = "bindingTemplate";
    static String UDDI_bindingTemplates = "bindingTemplates";
    static String UDDI_businessEntity = "businessEntity";
    static String UDDI_businessKey = "businessKey";
    static String UDDI_businessService = "businessService";
    static String UDDI_businessServices = "businessServices";
    static String UDDI_categoryBag = "categoryBag";
    static String UDDI_contact = "contact";
    static String UDDI_contacts = "contacts";
    static String UDDI_description = "description";
    static String UDDI_discoveryURL = "discoveryURL";
    static String UDDI_discoveryURLs = "discoveryURLs";
    static String UDDI_email = "email";
    static String UDDI_hostingRedirector = "hostingRedirector";
    static String UDDI_identifierBag = "identifierBag";
    static String UDDI_instanceDetails = "instanceDetails";
    static String UDDI_instanceParms = "instanceParms";
    static String UDDI_keyedReference = "keyedReference";
    static String UDDI_keyName = "keyName";
    static String UDDI_keyValue = "keyValue";
    static String UDDI_name = "name";
    static String UDDI_operator = "operator";
    static String UDDI_overviewDoc = "overviewDoc";
    static String UDDI_overviewURL = "overviewURL";
    static String UDDI_personName = "personName";
    static String UDDI_phone = "phone";
    static String UDDI_serviceKey = "serviceKey";
    static String UDDI_sortCode = "sortCode";
    static String UDDI_tModelInstanceDetails = "tModelInstanceDetails";
    static String UDDI_tModelInstanceInfo = "tModelInstanceInfo";
    static String UDDI_tModelKey = "tModelKey";
    static String UDDI_URLType = "URLType";
    static String UDDI_useType = "useType";
    static String UDDI_xmlLang = "xml:Lang";

    private static Element[] getChildElements(Element elt, String tag) {
        if (elt == null || tag == null || tag.trim().length() == 0) {
            return null;
        }
        NodeList nl = elt.getChildNodes();
        Vector<Element> v = new Vector<Element>();
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i) == null || !(nl.item(i) instanceof Element) || ((Element)nl.item(i)).getTagName().compareTo(tag) != 0) continue;
                v.add((Element)nl.item(i));
            }
        }
        Element[] childElements = null;
        if (v != null && v.size() > 0) {
            childElements = new Element[v.size()];
            v.toArray(childElements);
            v.clear();
        }
        return childElements;
    }

    protected static String getText(Element elt) {
        NodeList children;
        String text = "";
        if (elt != null && (children = elt.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i) == null || children.item(i).getNodeType() != 3) continue;
                text = text + children.item(i).getNodeValue();
            }
        }
        return text.trim();
    }

    private static String getAttr(Element element, String attrname) {
        if (element != null && element.getAttributeNode(attrname) != null && element.getAttributeNode(attrname).getSpecified()) {
            return element.getAttribute(attrname);
        }
        return null;
    }

    public static AccessPoint createAccessPoint(Element baseElement) throws Exception {
        AccessPoint accessPoint = null;
        if (baseElement != null) {
            accessPoint = new AccessPoint();
            accessPoint.setURL(WSUDDIUtils.getText(baseElement));
            accessPoint.setURLType(baseElement.getAttribute(UDDI_URLType));
        }
        return accessPoint;
    }

    public static Address createAddress(Element baseElement) throws Exception {
        Address address = null;
        if (baseElement != null) {
            address = new Address();
            address.setUseType(WSUDDIUtils.getAttr(baseElement, UDDI_useType));
            address.setSortCode(WSUDDIUtils.getAttr(baseElement, UDDI_sortCode));
            address.setTModelKey(WSUDDIUtils.getAttr(baseElement, UDDI_tModelKey));
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_addressLine);
            if (elements != null && elements.length > 0) {
                Vector<AddressLine> v = new Vector<AddressLine>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createAddressLine(elements[i]));
                }
                address.setAddressLineVector(v);
            }
        }
        return address;
    }

    public static AddressLine createAddressLine(Element baseElement) throws Exception {
        AddressLine addressLine = null;
        if (baseElement != null) {
            addressLine = new AddressLine();
            addressLine.setKeyName(WSUDDIUtils.getAttr(baseElement, UDDI_keyName));
            addressLine.setKeyValue(WSUDDIUtils.getAttr(baseElement, UDDI_keyValue));
            addressLine.setLineValue(WSUDDIUtils.getText(baseElement));
        }
        return addressLine;
    }

    public static BindingTemplate createBindingTemplate(Element baseElement) throws Exception {
        BindingTemplate bindingTemplate = null;
        if (baseElement != null) {
            bindingTemplate = new BindingTemplate();
            bindingTemplate.setBindingKey(baseElement.getAttribute(UDDI_bindingKey));
            bindingTemplate.setServiceKey(WSUDDIUtils.getAttr(baseElement, UDDI_serviceKey));
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_accessPoint);
            if (elements != null && elements.length > 0) {
                bindingTemplate.setAccessPoint(WSUDDIUtils.createAccessPoint(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_hostingRedirector)) != null && elements.length > 0) {
                bindingTemplate.setHostingRedirector(WSUDDIUtils.createHostingRedirector(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_tModelInstanceDetails)) != null && elements.length > 0) {
                bindingTemplate.setTModelInstanceDetails(WSUDDIUtils.createTModelInstanceDetails(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                Vector<Description> v = new Vector<Description>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                bindingTemplate.setDescriptionVector(v);
            }
        }
        return bindingTemplate;
    }

    public static BindingTemplates createBindingTemplates(Element baseElement) throws Exception {
        BindingTemplates bindingTemplates = null;
        if (baseElement != null) {
            bindingTemplates = new BindingTemplates();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_bindingTemplate);
            if (elements != null && elements.length > 0) {
                Vector<BindingTemplate> v = new Vector<BindingTemplate>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createBindingTemplate(elements[i]));
                }
                bindingTemplates.setBindingTemplateVector(v);
            }
        }
        return bindingTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessEntity createBusinessEntity(Element baseElement) throws Exception {
        String method = "createBusinessEntity";
        logger.entering(m_className, method);
        try {
            BusinessEntity businessEntity = null;
            if (baseElement != null) {
                int i;
                businessEntity = new BusinessEntity();
                businessEntity.setBusinessKey(baseElement.getAttribute(UDDI_businessKey));
                businessEntity.setOperator(WSUDDIUtils.getAttr(baseElement, UDDI_operator));
                businessEntity.setAuthorizedName(WSUDDIUtils.getAttr(baseElement, UDDI_authorizedName));
                Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_discoveryURLs);
                if (elements != null && elements.length > 0) {
                    businessEntity.setDiscoveryURLs(WSUDDIUtils.createDiscoveryURLs(elements[0]));
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_name)) != null && elements.length > 0) {
                    Vector<Name> nameVector = new Vector<Name>();
                    for (i = 0; i < elements.length; ++i) {
                        nameVector.addElement(WSUDDIUtils.createName(elements[i]));
                    }
                    businessEntity.setNameVector(nameVector);
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_contacts)) != null && elements.length > 0) {
                    businessEntity.setContacts(WSUDDIUtils.createContacts(elements[0]));
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_businessServices)) != null && elements.length > 0) {
                    businessEntity.setBusinessServices(WSUDDIUtils.createBusinessServices(elements[0]));
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_identifierBag)) != null && elements.length > 0) {
                    businessEntity.setIdentifierBag(WSUDDIUtils.createIdentifierBag(elements[0]));
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_categoryBag)) != null && elements.length > 0) {
                    businessEntity.setCategoryBag(WSUDDIUtils.createCategoryBag(elements[0]));
                }
                if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                    Vector<Description> description = new Vector<Description>();
                    for (i = 0; i < elements.length; ++i) {
                        description.addElement(WSUDDIUtils.createDescription(elements[i]));
                    }
                    businessEntity.setDescriptionVector(description);
                }
            }
            BusinessEntity businessEntity2 = businessEntity;
            Object var7_6 = null;
            logger.exiting(m_className, method);
            return businessEntity2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, method);
            throw throwable;
        }
    }

    public static BusinessService createBusinessService(Element baseElement) throws Exception {
        BusinessService businessService = null;
        if (baseElement != null) {
            int i;
            businessService = new BusinessService();
            businessService.setServiceKey(baseElement.getAttribute(UDDI_serviceKey));
            businessService.setBusinessKey(WSUDDIUtils.getAttr(baseElement, UDDI_businessKey));
            Vector<Object> v = null;
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_name);
            if (elements != null && elements.length > 0) {
                v = new Vector<Object>();
                elements = WSUDDIUtils.getChildElements(baseElement, UDDI_name);
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createName(elements[i]));
                }
                businessService.setNameVector(v);
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_bindingTemplates)) != null && elements.length > 0) {
                businessService.setBindingTemplates(WSUDDIUtils.createBindingTemplates(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_categoryBag)) != null && elements.length > 0) {
                businessService.setCategoryBag(WSUDDIUtils.createCategoryBag(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                v = new Vector();
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                businessService.setDescriptionVector(v);
            }
        }
        return businessService;
    }

    public static BusinessServices createBusinessServices(Element baseElement) throws Exception {
        BusinessServices businessServices = null;
        if (baseElement != null) {
            businessServices = new BusinessServices();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_businessService);
            if (elements != null && elements.length > 0) {
                Vector<BusinessService> v = new Vector<BusinessService>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createBusinessService(elements[i]));
                }
                businessServices.setBusinessServiceVector(v);
            }
        }
        return businessServices;
    }

    public static CategoryBag createCategoryBag(Element baseElement) throws Exception {
        CategoryBag categoryBag = null;
        if (baseElement != null) {
            categoryBag = new CategoryBag();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_keyedReference);
            if (elements != null && elements.length > 0) {
                Vector<KeyedReference> v = new Vector<KeyedReference>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createKeyedReference(elements[i]));
                }
                categoryBag.setKeyedReferenceVector(v);
            }
        }
        return categoryBag;
    }

    public static Contact createContact(Element baseElement) throws Exception {
        Contact contact = null;
        if (baseElement != null) {
            int i;
            Vector<Object> v = null;
            contact = new Contact();
            contact.setUseType(WSUDDIUtils.getAttr(baseElement, UDDI_useType));
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_personName);
            if (elements != null && elements.length > 0) {
                contact.setPersonName(WSUDDIUtils.createPersonName(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                v = new Vector<Object>();
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                contact.setDescriptionVector(v);
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_phone)) != null && elements.length > 0) {
                v = new Vector();
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createPhone(elements[i]));
                }
                contact.setPhoneVector(v);
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_email)) != null && elements.length > 0) {
                v = new Vector();
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createEmail(elements[i]));
                }
                contact.setEmailVector(v);
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_address)) != null && elements.length > 0) {
                v = new Vector();
                for (i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createAddress(elements[i]));
                }
                contact.setAddressVector(v);
            }
        }
        return contact;
    }

    public static Contacts createContacts(Element baseElement) throws Exception {
        Contacts contacts = null;
        if (baseElement != null) {
            contacts = new Contacts();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_contact);
            if (elements != null && elements.length > 0) {
                Vector<Contact> contact = new Vector<Contact>();
                for (int i = 0; i < elements.length; ++i) {
                    contact.addElement(WSUDDIUtils.createContact(elements[i]));
                }
                contacts.setContactVector(contact);
            }
        }
        return contacts;
    }

    public static Description createDescription(Element baseElement) throws Exception {
        Description description = null;
        if (baseElement != null) {
            description = new Description();
            description.setValue(WSUDDIUtils.getText(baseElement));
            description.setLanguageCode(baseElement.getAttribute(UDDI_xmlLang));
        }
        return description;
    }

    public static DiscoveryURL createDiscoveryURL(Element baseElement) throws Exception {
        DiscoveryURL discoveryURL = null;
        if (baseElement != null) {
            discoveryURL = new DiscoveryURL();
            discoveryURL.setValue(WSUDDIUtils.getText(baseElement));
            discoveryURL.setUseType(baseElement.getAttribute(UDDI_useType));
        }
        return discoveryURL;
    }

    public static DiscoveryURLs createDiscoveryURLs(Element baseElement) throws Exception {
        DiscoveryURLs discoveryURLs = null;
        if (baseElement != null) {
            discoveryURLs = new DiscoveryURLs();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_discoveryURL);
            if (elements != null && elements.length > 0) {
                Vector<DiscoveryURL> v = new Vector<DiscoveryURL>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDiscoveryURL(elements[i]));
                }
                discoveryURLs.setDiscoveryURLVector(v);
            }
        }
        return discoveryURLs;
    }

    public static Email createEmail(Element baseElement) throws Exception {
        Email email = null;
        if (baseElement != null) {
            email = new Email();
            email.setValue(WSUDDIUtils.getText(baseElement));
            email.setUseType(WSUDDIUtils.getAttr(baseElement, UDDI_useType));
        }
        return email;
    }

    public static HostingRedirector createHostingRedirector(Element baseElement) throws Exception {
        if (baseElement != null) {
            return new HostingRedirector(baseElement.getAttribute(UDDI_bindingKey));
        }
        return null;
    }

    public static IdentifierBag createIdentifierBag(Element baseElement) throws Exception {
        IdentifierBag identifierBag = null;
        if (baseElement != null) {
            identifierBag = new IdentifierBag();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_keyedReference);
            if (elements != null && elements.length > 0) {
                Vector<KeyedReference> v = new Vector<KeyedReference>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createKeyedReference(elements[i]));
                }
                identifierBag.setKeyedReferenceVector(v);
            }
        }
        return identifierBag;
    }

    public static InstanceDetails createInstanceDetails(Element baseElement) throws Exception {
        InstanceDetails instanceDetails = null;
        if (baseElement != null) {
            instanceDetails = new InstanceDetails();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_overviewDoc);
            if (elements != null && elements.length > 0) {
                instanceDetails.setOverviewDoc(WSUDDIUtils.createOverviewDoc(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_instanceParms)) != null && elements.length > 0) {
                instanceDetails.setInstanceParms(WSUDDIUtils.createInstanceParms(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                Vector<Description> v = new Vector<Description>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                instanceDetails.setDescriptionVector(v);
            }
        }
        return instanceDetails;
    }

    public static KeyedReference createKeyedReference(Element baseElement) throws Exception {
        KeyedReference keyedReference = null;
        if (baseElement != null) {
            keyedReference = new KeyedReference();
            keyedReference.setTModelKey(baseElement.getAttribute(UDDI_tModelKey));
            keyedReference.setKeyName(WSUDDIUtils.getAttr(baseElement, UDDI_keyName));
            keyedReference.setKeyValue(WSUDDIUtils.getAttr(baseElement, UDDI_keyValue));
        }
        return keyedReference;
    }

    public static Name createName(Element baseElement) throws Exception {
        Name name = null;
        if (baseElement != null) {
            name = new Name();
            name.setValue(WSUDDIUtils.getText(baseElement));
            name.setLanguageCode(WSUDDIUtils.getAttr(baseElement, UDDI_xmlLang));
        }
        return name;
    }

    public static InstanceParms createInstanceParms(Element baseElement) throws Exception {
        if (baseElement != null) {
            return new InstanceParms(WSUDDIUtils.getText(baseElement));
        }
        return null;
    }

    public static OverviewDoc createOverviewDoc(Element baseElement) throws Exception {
        OverviewDoc overviewDoc = null;
        if (baseElement != null) {
            overviewDoc = new OverviewDoc();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_overviewURL);
            if (elements != null && elements.length > 0) {
                overviewDoc.setOverviewURL(WSUDDIUtils.createOverviewURL(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                Vector<Description> v = new Vector<Description>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                overviewDoc.setDescriptionVector(v);
            }
        }
        return overviewDoc;
    }

    public static OverviewURL createOverviewURL(Element baseElement) throws Exception {
        if (baseElement != null) {
            return new OverviewURL(WSUDDIUtils.getText(baseElement));
        }
        return null;
    }

    public static PersonName createPersonName(Element baseElement) {
        if (baseElement != null) {
            return new PersonName(WSUDDIUtils.getText(baseElement));
        }
        return null;
    }

    public static Phone createPhone(Element baseElement) throws Exception {
        Phone phone = null;
        if (baseElement != null) {
            phone = new Phone();
            phone.setValue(WSUDDIUtils.getText(baseElement));
            phone.setUseType(WSUDDIUtils.getAttr(baseElement, UDDI_useType));
        }
        return phone;
    }

    public static TModelInstanceDetails createTModelInstanceDetails(Element baseElement) throws Exception {
        TModelInstanceDetails tModelInstanceDetails = null;
        if (baseElement != null) {
            tModelInstanceDetails = new TModelInstanceDetails();
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_tModelInstanceInfo);
            if (elements != null && elements.length > 0) {
                Vector<TModelInstanceInfo> v = new Vector<TModelInstanceInfo>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createTModelInstanceInfo(elements[i]));
                }
                tModelInstanceDetails.setTModelInstanceInfoVector(v);
            }
        }
        return tModelInstanceDetails;
    }

    public static TModelInstanceInfo createTModelInstanceInfo(Element baseElement) throws Exception {
        TModelInstanceInfo tModelInstanceInfo = null;
        if (baseElement != null) {
            tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey(baseElement.getAttribute(UDDI_tModelKey));
            Element[] elements = WSUDDIUtils.getChildElements(baseElement, UDDI_instanceDetails);
            if (elements != null && elements.length > 0) {
                tModelInstanceInfo.setInstanceDetails(WSUDDIUtils.createInstanceDetails(elements[0]));
            }
            if ((elements = WSUDDIUtils.getChildElements(baseElement, UDDI_description)) != null && elements.length > 0) {
                Vector<Description> v = new Vector<Description>();
                for (int i = 0; i < elements.length; ++i) {
                    v.addElement(WSUDDIUtils.createDescription(elements[i]));
                }
                tModelInstanceInfo.setDescriptionVector(v);
            }
        }
        return tModelInstanceInfo;
    }

    public static void saveToXML(Element parent, AccessPoint accessPoint) {
        if (accessPoint != null && parent != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_accessPoint);
            if (accessPoint.getURL() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(accessPoint.getURL()));
            }
            if (accessPoint.getURLType() != null) {
                element.setAttribute(UDDI_URLType, accessPoint.getURLType());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Address address) {
        if (parent != null && address != null) {
            Vector v;
            Element element = parent.getOwnerDocument().createElement(UDDI_address);
            if (address.getUseType() != null) {
                element.setAttribute(UDDI_useType, address.getUseType());
            }
            if (address.getSortCode() != null) {
                element.setAttribute(UDDI_sortCode, address.getSortCode());
            }
            if (address.getTModelKey() != null) {
                element.setAttribute(UDDI_tModelKey, address.getTModelKey());
            }
            if ((v = address.getAddressLineVector()) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (AddressLine)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, AddressLine addressLine) {
        if (parent != null && addressLine != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_addressLine);
            if (addressLine.getKeyName() != null) {
                element.setAttribute(UDDI_keyName, addressLine.getKeyName());
            }
            if (addressLine.getKeyValue() != null) {
                element.setAttribute(UDDI_keyValue, addressLine.getKeyValue());
            }
            if (addressLine.getLineValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(addressLine.getLineValue()));
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, BindingTemplate bindingTemplate) {
        if (parent != null && bindingTemplate != null) {
            Vector v;
            Element element = parent.getOwnerDocument().createElement(UDDI_bindingTemplate);
            if (bindingTemplate.getBindingKey() != null) {
                element.setAttribute(UDDI_bindingKey, bindingTemplate.getBindingKey());
            }
            if (bindingTemplate.getServiceKey() != null) {
                element.setAttribute(UDDI_serviceKey, bindingTemplate.getServiceKey());
            }
            if ((v = bindingTemplate.getDescriptionVector()) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (bindingTemplate.getAccessPoint() != null) {
                WSUDDIUtils.saveToXML(element, bindingTemplate.getAccessPoint());
            }
            if (bindingTemplate.getHostingRedirector() != null) {
                WSUDDIUtils.saveToXML(element, bindingTemplate.getHostingRedirector());
            }
            if (bindingTemplate.getTModelInstanceDetails() != null) {
                WSUDDIUtils.saveToXML(element, bindingTemplate.getTModelInstanceDetails());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, BindingTemplates bindingTemplates) {
        if (parent != null && bindingTemplates != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_bindingTemplates);
            Vector v = bindingTemplates.getBindingTemplateVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (BindingTemplate)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToXML(Element parent, BusinessEntity businessEntity) {
        if (parent != null && businessEntity != null) {
            String method = "saveToXML(businessEntity)";
            logger.entering(m_className, method);
            try {
                int i;
                Vector v;
                Element element = parent.getOwnerDocument().createElement(UDDI_businessEntity);
                if (businessEntity.getBusinessKey() != null) {
                    element.setAttribute(UDDI_businessKey, businessEntity.getBusinessKey());
                }
                if (businessEntity.getOperator() != null) {
                    element.setAttribute(UDDI_operator, businessEntity.getOperator());
                }
                if (businessEntity.getAuthorizedName() != null) {
                    element.setAttribute(UDDI_authorizedName, businessEntity.getAuthorizedName());
                }
                if (businessEntity.getDiscoveryURLs() != null) {
                    WSUDDIUtils.saveToXML(element, businessEntity.getDiscoveryURLs());
                }
                if ((v = businessEntity.getNameVector()) != null) {
                    for (i = 0; i < v.size(); ++i) {
                        WSUDDIUtils.saveToXML(element, (Name)v.elementAt(i));
                    }
                }
                if ((v = businessEntity.getDescriptionVector()) != null) {
                    for (i = 0; i < v.size(); ++i) {
                        WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                    }
                }
                if (businessEntity.getContacts() != null) {
                    WSUDDIUtils.saveToXML(element, businessEntity.getContacts());
                }
                if (businessEntity.getBusinessServices() != null) {
                    WSUDDIUtils.saveToXML(element, businessEntity.getBusinessServices());
                }
                if (businessEntity.getIdentifierBag() != null) {
                    WSUDDIUtils.saveToXML(element, businessEntity.getIdentifierBag());
                }
                if (businessEntity.getCategoryBag() != null) {
                    WSUDDIUtils.saveToXML(element, businessEntity.getCategoryBag());
                }
                parent.appendChild(element);
                Object var7_6 = null;
                logger.exiting(m_className, method);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                logger.exiting(m_className, method);
                throw throwable;
            }
        }
    }

    public static void saveToXML(Element parent, BusinessService businessService) {
        if (parent != null && businessService != null) {
            int i;
            Vector v;
            Element element = parent.getOwnerDocument().createElement(UDDI_businessService);
            if (businessService.getServiceKey() != null) {
                element.setAttribute(UDDI_serviceKey, businessService.getServiceKey());
            }
            if (businessService.getBusinessKey() != null) {
                element.setAttribute(UDDI_businessKey, businessService.getBusinessKey());
            }
            if ((v = businessService.getNameVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Name)v.elementAt(i));
                }
            }
            if ((v = businessService.getDescriptionVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (businessService.getBindingTemplates() != null) {
                WSUDDIUtils.saveToXML(element, businessService.getBindingTemplates());
            }
            if (businessService.getCategoryBag() != null) {
                WSUDDIUtils.saveToXML(element, businessService.getCategoryBag());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, BusinessServices businessServices) {
        if (parent != null && businessServices != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_businessServices);
            Vector v = businessServices.getBusinessServiceVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (BusinessService)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, CategoryBag categoryBag) {
        if (parent != null && categoryBag != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_categoryBag);
            Vector v = categoryBag.getKeyedReferenceVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (KeyedReference)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Contact contact) {
        if (parent != null && contact != null) {
            int i;
            Vector v;
            Element element = parent.getOwnerDocument().createElement(UDDI_contact);
            if (contact.getUseType() != null) {
                element.setAttribute(UDDI_useType, contact.getUseType());
            }
            if ((v = contact.getDescriptionVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (contact.getPersonName() != null) {
                WSUDDIUtils.saveToXML(element, contact.getPersonName());
            }
            if ((v = contact.getPhoneVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Phone)v.elementAt(i));
                }
            }
            if ((v = contact.getEmailVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Email)v.elementAt(i));
                }
            }
            if ((v = contact.getAddressVector()) != null) {
                for (i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Address)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Contacts contacts) {
        if (contacts != null && parent != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_contacts);
            Vector v = contacts.getContactVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Contact)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Description description) {
        if (parent != null && description != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_description);
            if (description.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(description.getValue()));
            }
            if (description.getLanguageCode() != null && !description.getLanguageCode().equals("")) {
                element.setAttribute(UDDI_xmlLang, description.getLanguageCode());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, DiscoveryURL discoveryURL) {
        if (parent != null && discoveryURL != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_discoveryURL);
            if (discoveryURL.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(discoveryURL.getValue()));
            }
            if (discoveryURL.getUseType() != null) {
                element.setAttribute(UDDI_useType, discoveryURL.getUseType());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, DiscoveryURLs discoveryURLs) {
        if (parent != null && discoveryURLs != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_discoveryURLs);
            Vector v = discoveryURLs.getDiscoveryURLVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (DiscoveryURL)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Email email) {
        if (parent != null && email != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_email);
            if (email.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(email.getValue()));
            }
            if (email.getUseType() != null) {
                element.setAttribute(UDDI_useType, email.getUseType());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, HostingRedirector hostingRedirector) {
        if (parent != null && hostingRedirector != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_hostingRedirector);
            if (hostingRedirector.getBindingKey() != null) {
                element.setAttribute(UDDI_bindingKey, hostingRedirector.getBindingKey());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, IdentifierBag identifierBag) {
        if (parent != null && identifierBag != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_identifierBag);
            Vector v = identifierBag.getKeyedReferenceVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (KeyedReference)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, InstanceDetails instanceDetails) {
        if (parent != null && instanceDetails != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_instanceDetails);
            Vector v = instanceDetails.getDescriptionVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (instanceDetails.getOverviewDoc() != null) {
                WSUDDIUtils.saveToXML(element, instanceDetails.getOverviewDoc());
            }
            if (instanceDetails.getInstanceParms() != null) {
                WSUDDIUtils.saveToXML(element, instanceDetails.getInstanceParms());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, InstanceParms instanceParms) {
        if (parent != null && instanceParms != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_instanceParms);
            if (instanceParms.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(instanceParms.getValue()));
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, KeyedReference keyedReference) {
        if (parent != null && keyedReference != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_keyedReference);
            if (keyedReference.getTModelKey() != null) {
                element.setAttribute(UDDI_tModelKey, keyedReference.getTModelKey());
            }
            if (keyedReference.getKeyName() != null) {
                element.setAttribute(UDDI_keyName, keyedReference.getKeyName());
            }
            if (keyedReference.getKeyValue() != null) {
                element.setAttribute(UDDI_keyValue, keyedReference.getKeyValue());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Name name) {
        if (parent != null && name != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_name);
            if (name.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(name.getValue()));
            }
            if (name.getLanguageCode() != null && !name.getLanguageCode().equals("")) {
                element.setAttribute(UDDI_xmlLang, name.getLanguageCode());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, OverviewDoc overviewDoc) {
        if (parent != null && overviewDoc != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_overviewDoc);
            Vector v = overviewDoc.getDescriptionVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (overviewDoc.getOverviewURL() != null) {
                WSUDDIUtils.saveToXML(element, overviewDoc.getOverviewURL());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, OverviewURL overviewURL) {
        if (parent != null && overviewURL != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_overviewURL);
            if (overviewURL.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(overviewURL.getValue()));
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, PersonName personName) {
        if (parent != null && personName != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_personName);
            if (personName.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(personName.getValue()));
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, Phone phone) {
        if (parent != null && phone != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_phone);
            if (phone.getValue() != null) {
                element.appendChild(parent.getOwnerDocument().createTextNode(phone.getValue()));
            }
            if (phone.getUseType() != null) {
                element.setAttribute(UDDI_useType, phone.getUseType());
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, TModelInstanceDetails tModelInstanceDetails) {
        if (parent != null && tModelInstanceDetails != null) {
            Element element = parent.getOwnerDocument().createElement(UDDI_tModelInstanceDetails);
            Vector v = tModelInstanceDetails.getTModelInstanceInfoVector();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (TModelInstanceInfo)v.elementAt(i));
                }
            }
            parent.appendChild(element);
        }
    }

    public static void saveToXML(Element parent, TModelInstanceInfo tModelInstanceInfo) {
        if (parent != null && tModelInstanceInfo != null) {
            Vector v;
            Element element = parent.getOwnerDocument().createElement(UDDI_tModelInstanceInfo);
            if (tModelInstanceInfo.getTModelKey() != null) {
                element.setAttribute(UDDI_tModelKey, tModelInstanceInfo.getTModelKey());
            }
            if ((v = tModelInstanceInfo.getDescriptionVector()) != null) {
                for (int i = 0; i < v.size(); ++i) {
                    WSUDDIUtils.saveToXML(element, (Description)v.elementAt(i));
                }
            }
            if (tModelInstanceInfo.getInstanceDetails() != null) {
                WSUDDIUtils.saveToXML(element, tModelInstanceInfo.getInstanceDetails());
            }
            parent.appendChild(element);
        }
    }

    public static String getErrMsg(RegistryException ex) {
        String msg = new String();
        if (ex != null) {
            Vector results;
            DispositionReport dr = ex.getDispositionReport();
            if (dr != null && (results = dr.getResultVector()) != null) {
                Result result = null;
                for (int i = 0; i < results.size(); ++i) {
                    if (results.get(i) == null || !(results.get(i) instanceof Result) || (result = (Result)results.get(i)).getErrInfo() == null || result.getErrInfo().getErrMsg() == null) continue;
                    if (msg.length() != 0) {
                        msg = msg + "\n";
                    }
                    msg = msg + result.getErrInfo().getErrMsg();
                }
            }
            if (msg == null || msg.length() == 0) {
                msg = ex.getLocalizedMessage();
            }
            if (msg == null || msg.length() == 0) {
                msg = ex.getMessage();
            }
        }
        return msg;
    }
}

